// Particle Connector.js
//
// ~/Library/Application Support/Cheetah3D/scripts/Splineobj folder


function buildUI(obj){
    obj.setParameter("name","Particle Connector");
    
    obj.addParameterLink("target particle", true);
    
    obj.addParameterFloat("distance threshold", 1, 0, 10000, true, true);
    
    obj.addParameterFloat("curve", 0, -100, 100, true, true);
    
    obj.addParameterLink("curve center", true);
    
    obj.addParameterSeparator("apprx. angle Setting");
    
    obj.addParameterFloat("apprx. angle", 5, 1, 90, false, false);
}

function setAngle( obj ) {
    obj.setParameter("angle", obj.getParameter("apprx. angle"));
}

function buildObject(obj){
    var core = obj.core();
    
    var particleObj = obj.getParameter("target particle");
    
    if (!particleObj || particleObj.family() != PARTICLEFAMILY) return;
    
    var threshold = obj.getParameter("distance threshold");
    var curve = obj.getParameter("curve");
    var curveTarget = obj.getParameter("curve center");
    
    var curveCenter = (curveTarget)? curveTarget.getParameter("position") : new Vec3D(0, 0, 0);
    
    if (threshold == 0) return;
    
    obj.setParameter("angle", obj.getParameter("apprx. angle"), false);
    
    //var mat = particleObj.objMatrix();
    var particleCore = particleObj.core();
    var count = particleCore.particleCount();
    
    var posCache = [];
    
    //print( '---' );
    // calculating particle grid size.
    var gridMax = new Vec3D();
    var gridMin = new Vec3D();
    for (var i = 0;i < count;i++) {
        //var pos = mat.multiply( particleCore.particleAtIndex( i ).getPosition() );
        var pos = particleCore.particleAtIndex( i ).getPosition();
        
        gridMax.x = Math.max( pos.x, gridMax.x );
        gridMax.y = Math.max( pos.y, gridMax.y );
        gridMax.z = Math.max( pos.z, gridMax.z );
        
        gridMin.x = Math.min( pos.x, gridMin.x );
        gridMin.y = Math.min( pos.y, gridMin.y );
        gridMin.z = Math.min( pos.z, gridMin.z );
        
        posCache[i] = pos;
    }
    
    gridMax = gridMax.add( new Vec3D( 0.001, 0.001, 0.001 ) );
    //gridMin = gridMin.sub( new Vec3D( 0.001, 0.001, 0.001 ) );
    
    // calculating gird size.
    var gridSizeX = Math.ceil( Math.abs( gridMax.x - gridMin.x ) / (threshold) );
    var gridSizeY = Math.ceil( Math.abs( gridMax.y - gridMin.y ) / (threshold) );
    var gridSizeZ = Math.ceil( Math.abs( gridMax.z - gridMin.z ) / (threshold) );
    
    // grid size limitter
    gridSizeX = (gridSizeX > 100)? 100 : gridSizeX;
    gridSizeY = (gridSizeY > 100)? 100 : gridSizeY;
    gridSizeZ = (gridSizeZ > 100)? 100 : gridSizeZ;
    
    
    // create grid array
    var grid = new Array;
    for (var i = 0;i < gridSizeX;i++) {
        grid[i] = new Array;
        for (var j = 0;j < gridSizeY;j++) {
            grid[i][j] = new Array;
            for (var k = 0;k < gridSizeZ;k++) {
                grid[i][j][k] = new Array;
            }
        }
    }
    
    var cache = [];
    
    // caching particles to grid
    var dx = Math.abs( (gridMax.x - gridMin.x) / (gridSizeX) );
    var dy = Math.abs( (gridMax.y - gridMin.y) / (gridSizeY) );
    var dz = Math.abs( (gridMax.z - gridMin.z) / (gridSizeZ) );
    //print( 'gridSizeX:'+gridSizeX+', gridSizeY:'+gridSizeY+', gridSizeZ:'+gridSizeZ);
    //print( 'dx:'+dx.toFixed(3)+', dy:'+dy.toFixed(3)+' dz:'+dz.toFixed(3) );
    
    // draw grid
    
    /*
    for (var i =0;i < gridSizeX;i++) {
        for (var j =0;j < gridSizeY;j++) {
            for (var k =0;k < gridSizeZ;k++) {
                core.move( new Vec3D( gridMin.x + dx*i, gridMin.y + dy*j, gridMin.z + dz*k ) );
                core.line( new Vec3D( gridMin.x + dx*(i+1), gridMin.y + dy*j, gridMin.z + dz*k ) );
                core.move( new Vec3D( gridMin.x + dx*i, gridMin.y + dy*j, gridMin.z + dz*k ) );
                core.line( new Vec3D( gridMin.x + dx*i, gridMin.y + dy*(j+1), gridMin.z + dz*k ) );
                core.move( new Vec3D( gridMin.x + dx*i, gridMin.y + dy*j, gridMin.z + dz*k ) );
                core.line( new Vec3D( gridMin.x + dx*i, gridMin.y + dy*j, gridMin.z + dz*(k+1) ) );
            }
        }
    }
     */
     
    //
    for (var i = 0;i < count;i++) {
        var pos = posCache[ i ];
        
        var xi = Math.floor( (pos.x - gridMin.x) / dx );
        var yi = Math.floor( (pos.y - gridMin.y) / dy );
        var zi = Math.floor( (pos.z - gridMin.z) / dz );
        
        //print( i+':['+xi+']['+yi+'['+zi+']' );
        grid[xi][yi][zi].push( i );
        cache[i] = [];
    }
    
    
    // creating spline for all particles
    for (var i = 0;i < count;i++) {
        var pos = posCache[ i ];
        
        var xi = Math.floor( (pos.x - gridMin.x) / dx );
        var yi = Math.floor( (pos.y - gridMin.y) / dy );
        var zi = Math.floor( (pos.z - gridMin.z) / dz );
        
        // getting cached particles
        var list = [];
        for (var ii = -1;ii < 2;ii++) {
            for (var jj = -1;jj < 2;jj++) {
                for (var kk = -1;kk < 2;kk++) {
                    var xj = xi + ii;
                    var yj = yi + jj;
                    var zj = zi + kk;
                    
                    if (xj < 0 || yj < 0 || zj < 0) continue;
                    if (xj >= gridSizeX || yj >= gridSizeY || zj >= gridSizeZ ) continue;
                    
                    //print( '['+xj+']['+yj+'['+zj+']:' + grid[xj][yj][zj] );
                    list = list.concat( grid[xj][yj][zj] );
                }
            }
        }
        
        var len = list.length;
        //print( i + ':' + list );
        for (j = 0;j < len;j++) {
            
            if (list[j] != i && cache[ list[j] ].indexOf( i ) < 0) { // 
                var subpos = particleCore.particleAtIndex( list[j] ).getPosition();
                var dist = Vec3D_distanceTo( pos, subpos );
                
                if (dist > threshold) {
                    //print( i + ':' + dist );
                    continue;
                }
                
                core.move( pos );
                if (curve != 0 && ( pos.norm() > 0.00000001 && subpos.norm() > 0.0000001 )) {
                    var cp1 = pos.multiply( 0.8 ).add( subpos.multiply( 0.2 ) );
                    var cp2 = pos.multiply( 0.2 ).add( subpos.multiply( 0.8 ) );
                    var mid = pos.add( subpos ).multiply( 0.5 ).sub( curveCenter );
                    mid = mid.multiply( 1/mid.norm() );
                    
                    cp1 = cp1.add( mid.multiply( dist * curve ) );
                    cp2 = cp2.add( mid.multiply( dist * curve ) );
                    
                    core.curve( cp1, cp2, subpos );
                } else {
                    core.line( subpos );
                }
                cache[ i ].push( list[j] );
            }
        }
    }

}

var Vec3D_toString = function() {
    return '(' + arguments[0].x.toFixed(3) + ', ' + arguments[0].y.toFixed(3) + ', ' + arguments[0].z.toFixed(3) + ')';
}

var Vec3D_distanceTo = function() {
	var dx = 0, dy = 0, dz = 0;
	if ( arguments.length == 2 ) {
		dx = arguments[0].x - arguments[1].x;
		dy = arguments[0].y - arguments[1].y;
		dz = arguments[0].z - arguments[1].z;
		
	} else if ( arguments.length == 4 ) {
		dx = arguments[0].x - arguments[1];
		dy = arguments[0].y - arguments[2];
		dz = arguments[0].z - arguments[3];
		
	}
	return Math.sqrt( ( dx * dx + dy * dy + dz * dz ) );
}
